require("scripts/maps/map_helpers.lua");
SetMapBackground("map/dinertown/background");
MakeDialog
{
	Window
	{
		x = 0, y = 0, w = kMax, h = kMax,
		

		
		Button
		{
			x = 282,
			y = 213,
			rolloverwindow = 'dt_flosdiner_rollover',
			graphics = {"map/dinertown/flosdiner/map_a","map/dinertown/flosdiner/map_b","map/dinertown/flosdiner/map_b"};
			command =
				function()
					DoModal('scripts/floscorner1.lua');
				end
		};
		
		Bitmap
		{
			x = 63,
			y = 360,
			image = "map/dinertown/cruiseship/map_c"
		};
		
		Bitmap
		{
			x = 138,
			y = 255,
			image = "map/dinertown/dd2tower/map_c"
		};
		
		Bitmap
		{
			x = 322,
			y = 0,
			image = "map/dinertown/movietheater/map_c"
		};
		
		Button
		{
			x = 705,
			y = 191,
			name = "dt_weddingoffice",
			rolloverwindow = 'dt_weddingoffice_rollover',
			graphics = {"map/dinertown/weddingoffice/map_a", "map/dinertown/weddingoffice/map_b", "map/dinertown/weddingoffice/map_b"};
			command = 
				function()
					LaunchHarnessPost('upsell/upsell_WD.html', 'Main');
				end		
		};
		
		Bitmap
		{
			x = 322,
			y = 0,
			image = "map/dinertown/movietheater/map_c",
		};
		
		SetStyle(SolidButtonStyle);
		
		MovingWindow
		{
			name="maprighttray",
			x=673,y=274,
			dirX = 5,
			dirY = 0,
			startoff = 1,
			onDelay = 500,
			
			Bitmap
			{
				image = "map/map_tray",
				x = 0,
				y = 0,
				hflip = true,
				
				Text
				{
					x = 20, y = 95,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignTop,
					name = 'maprightlabel',
					label = 'map_3_right',
					font = MapArrowFont,
				}
			};
			
			
			Button
			{
				
				x=48,
				y=22,
				name="mapright",
				graphics=NextMapGraphics,
				label="",
				hflip = true,
				sound = "audio/sfx/train.ogg",
				SelectLayer(0),
				Bitmap
				{
					x=14,
					y=25,
					hflip=true,
					image = 'map/train_logo'
				};
				SelectLayer(1),
				Bitmap
				{
					x=12,
					y=27,
					hflip=true,
					image = 'map/train_logo'
				};
				SelectLayer(2),
				Bitmap
				{
					x=14,
					y=25,
					hflip=true,
					image = 'map/train_logo'
				};
				command=
					function()
						FadeWindow("mapfadepanel", false);
						while (IsWindowFading("mapfadepanel")) do
							Pause(10);
						end
						SwitchMapPage('1');
						
						SetupCurrentMapPage();
						FadeWindow("mapfadepanel", true);
						while (IsWindowFading("mapfadepanel")) do
							Pause(10);
						end
					end
			},
			
			
			
		};
			
		MovingWindow
		{
			name="mapmicrowavetray",
 			x=348,y=00,
 			dirX = 0,
 			dirY = -5,
 			startoff = 1,
 			onDelay = 500,	
			
			Bitmap
			{
				image = "map/map_tray_vertical",
				x = 0,
				y = 0,
				
				Text
				{
					x = 8, y = 75,
					w = kMax, h = kMax,
					flags = kHAlignCenter + kVAlignTop,
					name = 'mapuplabel',
					label = 'map_1_microwave',
					font = MapArrowFont,
				}
			};
			
			
			Button
			{
				
				x=28,
				y=2,
				name="mapup",
				graphics=NextMapUpGraphics,
				label="",
				hflip = true,
				SelectLayer(0),
				Bitmap
				{
					x=34,
					y=26,
					hflip=true,
					image = 'map/microwave_logo'
				};
				SelectLayer(1),
				Bitmap
				{
					x=32,
					y=28,
					hflip=true,
					image = 'map/microwave_logo'
				};
				SelectLayer(2),
				Bitmap
				{
					x=34,
					y=26,
					hflip=true,
					image = 'map/microwave_logo'
				};
				command=
					function()
						FadeWindow("mapfadepanel", false);
						while (IsWindowFading("mapfadepanel")) do
							Pause(10);
						end
						SwitchMapPage('microwave');
						
						SetupCurrentMapPage();
						FadeWindow("mapfadepanel", true);
						while (IsWindowFading("mapfadepanel")) do
							Pause(10);
						end
					end
			},
		};
 		
		MakeDinertownRollover(100,200,'dt_flosdiner');
		MakeDinertownRollover(420,165,'dt_weddingoffice');
		
		SetStyle(MapForSaleStyle);
		MakeRestaurantButtons('winter', 125, 45, 30, 54);
		MakeRestaurantButtons('valentines', 270, 320, 150, 330);
		SetStyle(DefaultStyle);
	};
};


SlideMovingWindow('maprighttray', true);
SlideMovingWindow('mapmicrowavetray', true);

EnableWindow('dt_flosdiner_rollover', false);
EnableWindow('dt_cruiseship_rollover', false);
EnableWindow('dt_dd2tower_rollover', false);
EnableWindow('dt_movietheater_rollover', false);
EnableWindow('dt_weddingoffice_rollover', false);

HideRestaurantButtons('winter');
HideRestaurantButtons('valentines');
EnableWindow('winter_rollover', false);
EnableWindow('valentines_rollover', false);
